//
//  $Id: AHKMail.h 94 2009-06-11 15:28:02Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//

#import <Foundation/Foundation.h>

//#define AHKEmailOutboxMaximumNumber 900
//#define AHKEmailInboxMaximumNumber 900
//#define AHKLightMailInboxMaximumNumber 100
//#define AHKLightMailOutboxMaximumNumber 100

typedef enum {
	AHKSentMailBox	= 1,
	AHKDraftMailBox	= 2,
	AHKInboxMailBox	= 3
} AHKMailBox;


// Super class of AHKLightMail and AHKEmail.
@interface AHKMail : NSObject <NSCoding>
{
	int box;
	int number;
	int status;
	BOOL secured;
	NSData *data;
}

// designated initializer
- (id)initWithData:(NSData *)datum box:(int)aBox number:(int)aNumber status:(int)aStatus isSecured:(BOOL)flag;

- (int)box;
- (void)setBox:(int)value;
- (int)number;
- (void)setNumber:(int)value;
- (int)status;
- (void)setStatus:(int)value;
- (BOOL)isSecured;
- (void)setSecured:(BOOL)flag;
- (NSData *)data;
- (void)setData:(NSData *)value;

@end


// --- subclass must override this methods
@protocol AHKMailing

- (NSString *)from;
- (NSString *)to;
- (NSDate *)date;
- (NSData *)message;
- (NSString *)subject;
- (NSString *)body;

@end


@interface AHKEmail : AHKMail <AHKMailing>
{
	NSDictionary *headerDictionary;
	NSString *body;
}

- (id)initWithData:(NSData *)datum box:(int)aBox number:(int)aNumber status:(int)aStatus isSecured:(BOOL)flag;
- (NSDictionary *)headerDictionary;
- (NSString *)object;

@end


@interface AHKLightMail : AHKMail <AHKMailing, NSCoding>
{
	NSString *object;
	NSDate *date;
}

+ (NSString *)usersPhoneNumber;
+ (void)setUsersPhoneNumber:(NSString *)value;

- (id)initWithData:(NSData *)datum box:(int)aBox number:(int)aNumber status:(int)aStatus isSecured:(BOOL)flag object:(NSString *)anObject dateString:(NSString *)aDateString;

- (NSString *)object;
- (void)setObject:(NSString *)value;
- (NSDate *)date;
- (void)setDate:(NSDate *)value;
- (NSString *)from;
- (NSString *)to;

@end
